// Craig S. Kaplan
// Progressively draw a random snowflake by drawing random
// black and white triangles and all their symmetric copies.
// Press a key to add a new triangle.

// It's tempting to put the calls to random() in here.  But
// if you do that, then every individual "copy" of the triangle
// will in fact be different from the others.  We'll come back
// to this topic a bit later in the term.  Instead, we expect
// an array of the coordinates of a triangle to be passed down
// to us.
void drawHalfArm( float[] cs )
{
  triangle( cs[0], cs[1], cs[2], cs[3], cs[4], cs[5] );
}

// Draw a triangle together with its mirror image.
void drawSymmetricArm( float[] cs )
{
  pushMatrix();
  drawHalfArm( cs );
  scale( -1.0, 1.0 );
  drawHalfArm( cs );
  popMatrix();
}

// Draw six copies of a triangle with its mirror image.
void drawTri( float[] cs )
{
  pushMatrix();
  for( int idx = 0; idx < 6; ++idx ) {
    drawSymmetricArm( cs );
    rotate( radians( 60 ) );
  }
  popMatrix();
}

void setup()
{
  size( 500, 500 );
  
  background( 0 );
  fill( 255 );
  noStroke();
}

void draw()
{}

void keyPressed()
{ 
  float[] cs = {
    random( 100 ), random( 200 ), 
    random( 100 ), random( 200 ),
    random( 100 ), random( 200 ) };
    
  if( random( 1 ) < 0.25 ) {
    fill( 0 );
  } else {
    fill( 255 );
  }
    
  pushMatrix();
  translate( 250, 250 );
  drawTri( cs );
  popMatrix();
}